/**********************************************************************************************
	Container MacroScript File

	This file contains scripted commands related to Missing Plugin Entities Explorer
	
	Author:   Chengqing Zhou

	MODIFY THIS AT YOUR OWN RISK
***********************************************************************************************/

macroScript OpenMissingPluginEntitiesExplorer 
category:~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_CATEGORY~  
internalCategory:"Scene Explorer" 
ButtonText:~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_BUTTONTEXT~ 
tooltip:~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_TOOLTIP~  
-- No icon yet
(
	on isEnabled return true
	on isChecked return false
	on isVisible do
	(
		plugInCount = SceneMissingPlugIns.GetMissingPlugInCount()
		ret = false
		-- if currently no missing plug-in, don't show it
		if ( plugInCount > 0) do
		(
			ret = true
		)
		return ret
	)

	on execute do
	(
		-- If the Missing Plugin Entities Explorer has not been loaded yet, do it now.
		-- We rely on the explorer name "Missing Plugin Entities Explorer" as defined in the 
		-- InstanceName field of the "DefaultMissingPluginEntitiesExplorer.ini" file.
		if not SceneExplorerManager.ExplorerExists ~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_CAPTION~  then
		(
			local cfgpath = pathConfig.GetDir #plugcfg
			cfgpath = pathConfig.appendPath cfgpath "ExplorerConfig\SceneExplorer"
			local cfgfile = pathConfig.appendPath cfgpath "DefaultMissingPluginEntitiesExplorer.ini"
			SceneExplorerManager.LoadExplorerConfiguration cfgfile
		)
		SceneExplorerManager.OpenExplorer ~OPEN_MISSING_PLUGIN_ENTITIES_EXPLORER_TITLE~ 
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQC1s9tbXG8tlbzMNAZeCnFG5bEFN5ufdHqE
-- xhvDQKkDoftfkJ+mOBjs+tl/0jyXKJBqV8BHvYiN+986Kqe3cjeNJnCqv+ixPmzW
-- RhEu0tY4B+E04hAjOSBAlivGhiJnqfMxK0gwx1DYCmKIimRmfpgbM2wkyYhwjsKs
-- BNjmimoTaZ6qwhcrW/8P0AMJ0iuJ9CU5z0lRLjIVvamFDBBZDBh8nH0AqC0o2nao
-- wjvLc4LXTwzpu4WZPh60i5l2lfBk10caFoIUrtRhI7F7/avaxDs6L5tbmKHlMPOv
-- 63LXakWEyT9yO0VJnE9EREx+65fqxOr0asEgiPzQJUlfZ+Kvf5FP
-- -----END-SIGNATURE-----